#ifndef __WM_WDRT_DEMO_H__
#define __WM_WDRT_DEMO_H__

typedef enum {
    WM_WDRT_MODE_RX,
    WM_WDRT_MODE_TX
} wm_wdrt_mode;

typedef void (*wm_wdrt_rx_callback)(const u8 * src_mac, u8* data, u32 data_len);

typedef struct {
    wm_wdrt_mode mode; /* rx or tx */
    int work_channel; /* 1-14 */
    u8 da[ETH_ALEN]; /* destination address */
    enum tls_wifi_tx_rate tx_rate;

    u8 *tx_data;
    u16 tx_data_len;

    wm_wdrt_rx_callback rx_callback;
} wm_wdrt_cfg;

void wm_wdrt_demo(wm_wdrt_cfg *cfg);

#endif /* __WM_WDRT_DEMO_H__ */

